<?php

use App\Http\Controllers\Api\LeaguesController;
use App\Http\Controllers\Api\FixturesController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\FootballController;


Route::prefix('v1')->group(function () {
    // Leagues endpoints
    Route::get('/leagues', [LeaguesController::class, 'getLeagues']);
    Route::get('/leagues/{id}', [LeaguesController::class, 'getLeague']);
    Route::get('/leagues/country/{countryId}', [LeaguesController::class, 'getLeaguesByCountry']);
    // ✅ Specific route first
    Route::get('/leagues/live', [LeaguesController::class, 'getLiveLeagues']);

    // ❗ Put wildcard routes after specific ones
    Route::get('/leagues/{id}', [LeaguesController::class, 'show'])->where('id', '[0-9]+');
    Route::get('/leagues/fixture-date', [LeaguesController::class, 'getLeaguesByFixtureDate']);
    Route::get('/leagues/search', [LeaguesController::class, 'searchLeaguesByName']);
   Route::get('/leagues/team/{team_id}', [LeaguesController::class, 'getAllLeaguesByTeamId']);
   Route::get('/leagues/team/{team_id}/current', [LeaguesController::class, 'getCurrentLeaguesByTeamId']);
   Route::get('/leagues/{league_id}/shirts', [LeaguesController::class, 'getShirtsByLeagueId']);
    // Fixtures endpoints
    Route::get('/fixtures', [FixturesController::class, 'getFixtures']);
    Route::get('/fixtures/{id}', [FixturesController::class, 'getFixture']);
    Route::get('/fixtures/multiple/{ids}', [FixturesController::class, 'getFixturesByIds']);
    Route::get('/fixtures/date-range', [FixturesController::class, 'getFixturesByDateRange']);
    Route::get('/fixtures/head-to-head/{team1Id}/{team2Id}', [FixturesController::class, 'getHeadToHeadFixtures']);
    Route::get('/fixtures/latest-updated', [FixturesController::class, 'getLatestUpdatedFixtures']);
    Route::get('/fixtures/team/{teamId}/date-range', [FixturesController::class, 'getFixturesByDateRangeForTeam']);
    Route::get('/fixtures/search', [FixturesController::class, 'searchFixturesByName']);
    Route::get('/fixtures/upcoming/market/{marketId}', [FixturesController::class, 'getUpcomingFixturesByMarketId']);
    Route::get('/fixtures/upcoming/tv-station/{tvStationId}', [FixturesController::class, 'getUpcomingFixturesByTvStationId']);
    Route::get('/fixtures/past/tv-station/{tvStationId}', [FixturesController::class, 'getPastFixturesByTvStationId']);
    Route::get('/fixtures/league/{leagueId}', [FixturesController::class, 'getFixturesByLeague']);
    Route::get('/fixtures/team/{teamId}', [FixturesController::class, 'getFixturesByTeam']);
    Route::get('/fixtures/live', [FixturesController::class, 'getLiveFixtures']);
    Route::get('/fixtures/upcoming', [FixturesController::class, 'getUpcomingFixtures']);
});
