<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('teams', function (Blueprint $table) {
            $table->id();
            $table->integer('sportmonks_id')->unique();
            $table->string('name');
            $table->integer('sport_id')->nullable()->index();
            $table->integer('country_id')->nullable()->index();
            $table->integer('venue_id')->nullable()->index();
            $table->string('gender')->nullable();
            $table->string('short_code')->nullable();
            $table->string('image_path')->nullable();
            $table->integer('founded')->nullable();
            $table->string('type')->nullable();
            $table->boolean('placeholder')->default(false);
            $table->timestamp('last_played_at')->nullable();
            $table->jsonb('trophies')->nullable();
            $table->jsonb('transfers')->nullable();
            $table->jsonb('squads')->nullable();
            $table->jsonb('stats')->nullable();
            $table->timestamps();
        });

        // DB::statement('ALTER TABLE teams SET TABLESPACE dev_data;');
    }

    public function down(): void
    {
        Schema::dropIfExists('teams');
    }
};