<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('fixtures', function (Blueprint $table) {
            $table->id();
            $table->integer('sportmonks_id')->unique();
            $table->integer('league_id')->nullable()->index();
            $table->integer('home_team_id')->nullable()->index();
            $table->integer('away_team_id')->nullable()->index();
            $table->integer('sport_id')->nullable();
            $table->integer('season_id')->nullable();
            $table->integer('stage_id')->nullable();
            $table->integer('group_id')->nullable();
            $table->integer('round_id')->nullable();
            $table->integer('venue_id')->nullable();
            $table->string('name')->nullable();
            $table->timestamp('starting_at')->nullable();
            $table->string('status')->nullable();
            $table->string('leg')->nullable();
            $table->integer('length')->nullable();
            $table->boolean('placeholder')->default(false);
            $table->boolean('has_odds')->default(false);
            $table->boolean('has_premium_odds')->default(false);
            $table->jsonb('details')->nullable();
            $table->timestamps();
        });

        // DB::statement('ALTER TABLE fixtures SET TABLESPACE dev_data;');
    }

    public function down(): void
    {
        Schema::dropIfExists('fixtures');
    }
};