<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('leagues', function (Blueprint $table) {
            $table->id();
            $table->integer('sportmonks_id')->unique();
            $table->string('name');
            $table->integer('sport_id')->nullable()->index();
            $table->integer('country_id')->nullable()->index();
            $table->boolean('active')->default(true);
            $table->string('short_code')->nullable();
            $table->string('image_path')->nullable();
            $table->string('type')->nullable();
            $table->string('sub_type')->nullable();
            $table->timestamp('last_played_at')->nullable();
            $table->integer('category')->nullable();
            $table->boolean('has_jerseys')->default(false);
            $table->jsonb('details')->nullable();
            $table->timestamps();
        });

        // DB::statement('ALTER TABLE leagues SET TABLESPACE dev_data;');
    }

    public function down(): void
    {
        Schema::dropIfExists('leagues');
    }
};