<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('players', function (Blueprint $table) {
            $table->id();
            $table->integer('sportmonks_id')->unique();
            $table->string('name');
            $table->string('common_name')->nullable();
            $table->string('firstname')->nullable();
            $table->string('lastname')->nullable();
            $table->string('display_name')->nullable();
            $table->integer('team_id')->nullable()->index();
            $table->integer('country_id')->nullable()->index();
            $table->integer('position_id')->nullable();
            $table->integer('detailed_position_id')->nullable();
            $table->integer('type_id')->nullable();
            $table->string('image_path')->nullable();
            $table->integer('height')->nullable();
            $table->integer('weight')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('gender')->nullable();
            $table->jsonb('stats')->nullable();
            $table->jsonb('injuries')->nullable();
            
            // New fields for better sync tracking
            $table->timestamp('last_sync_at')->nullable();
            $table->timestamp('api_updated_at')->nullable();
            
            $table->timestamps();
            
            // Add composite index for better performance
            $table->index(['team_id', 'position_id']);
        });

        // DB::statement('ALTER TABLE players SET TABLESPACE dev_data;');
    }

    public function down(): void
    {
        Schema::dropIfExists('players');
    }
};