<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('predictions', function (Blueprint $table) {
            $table->id();
            $table->integer('match_id')->index();
            $table->string('prediction_type'); // e.g., 'result', 'btts', 'over_under'
            $table->string('value');
            $table->float('probability')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('predictions');
    }
};
