<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('odds', function (Blueprint $table) {
            $table->id();
            $table->integer('match_id')->index();
            $table->string('market'); // e.g., '1x2', 'over_under'
            $table->float('value');
            $table->string('bookmaker');
            $table->boolean('is_prematch')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('odds');
    }
};
