<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('topscorers', function (Blueprint $table) {
            $table->id();
            $table->integer('league_id')->index();
            $table->integer('player_id')->index();
            $table->integer('goals');
            $table->integer('assists')->nullable();
            $table->jsonb('details')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('topscorers');
    }
};
