<?php

use Illuminate\Container\Attributes\DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB as FacadesDB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
 public function up(): void
{
    Schema::create('matches', function (Blueprint $table) {
        $table->id();
        $table->integer('sportmonks_id')->unique();
        $table->integer('league_id')->index();
        $table->integer('home_team_id');
        $table->integer('away_team_id');
        $table->timestamp('start_time')->nullable();
        $table->string('status')->index();
        $table->string('score')->nullable();
        $table->json('events')->nullable();
        $table->json('tv_stations')->nullable();
        $table->json('commentaries')->nullable();
        $table->json('stats')->nullable();
        $table->json('lineups')->nullable();
        $table->json('ball_coordinates')->nullable();
        $table->json('trends')->nullable();
        $table->json('standings')->nullable();
        $table->timestamps();
    });

    // Set tablespace (run raw SQL since Laravel doesn’t support tablespaces natively)
    DB::statement('ALTER TABLE matches SET TABLESPACE dev_data;');
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('matches');
    }
};
