<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Topscorers extends Model
{
    protected $table = 'top_scorers';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'league_id',
        'player_id',
        'goals',
        'assists',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function league()
    {
        return $this->belongsTo(Leagues::class, 'league_id');
    }

    public function player()
    {
        return $this->belongsTo(Players::class, 'player_id');
    }
}
