<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    protected $table = 'teams';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'sportmonks_id',
        'name',
        'sport_id',
        'country_id',
        'venue_id',
        'gender',
        'short_code',
        'image_path',
        'founded',
        'type',
        'placeholder',
        'last_played_at',
        'trophies',
        'transfers',
        'squads',
        'stats',
    ];

    protected $casts = [
        'trophies' => 'array',
        'transfers' => 'array',
        'squads' => 'array',
        'stats' => 'array',
        'placeholder' => 'boolean',
        'last_played_at' => 'datetime',
    ];

    public function leagues()
{
    return $this->belongsToMany(Leagues::class, 'teamandleagues', 'team_id', 'league_id');
}
}