<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Standings extends Model
{
     protected $table = 'standings';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'league_id',
        'team_id',
        'position',
        'points',
        'played',
        'won',
        'drawn',
        'lost',
        'goals_for',
        'goals_against',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function league()
    {
        return $this->belongsTo(Leagues::class, 'league_id');
    }

    public function team()
    {
        return $this->belongsTo(Teams::class, 'team_id');
    }
}
