<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Players extends Model
{
    protected $table = 'players';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'sportmonks_id',
        'name',
        'common_name',
        'firstname',
        'lastname',
        'display_name',
        'team_id',
        'country_id',
        'position_id',
        'detailed_position_id',
        'type_id',
        'image_path',
        'height',
        'weight',
        'date_of_birth',
        'gender',
        'stats',
        'injuries',
        'last_sync_at',       // New field
        'api_updated_at',     // New field
    ];

    protected $casts = [
        'stats' => 'array',
        'injuries' => 'array',
        'date_of_birth' => 'date',
    ];

    public function team()
    {
        return $this->belongsTo(Teams::class, 'team_id');
    }
}