<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Matches extends Model
{
    protected $table = 'matches';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'sportmonks_id',
        'league_id',
        'home_team_id',
        'away_team_id',
        'start_time',
        'status',
        'score',
        'events',
        'tv_stations',
        'commentaries',
        'stats',
        'lineups',
        'ball_coordinates',
        'trends',
        'standings',
    ];

    protected $casts = [
        'events' => 'array',
        'tv_stations' => 'array',
        'commentaries' => 'array',
        'stats' => 'array',
        'lineups' => 'array',
        'ball_coordinates' => 'array',
        'trends' => 'array',
        'standings' => 'array',
    ];
}