<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Leagues extends Model
{
    protected $table = 'leagues';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'sportmonks_id',
        'name',
        'sport_id',
        'country_id',
        'active',
        'short_code',
        'image_path',
        'type',
        'sub_type',
        'last_played_at',
        'category',
        'has_jerseys',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
        'active' => 'boolean',
        'has_jerseys' => 'boolean',
        'last_played_at' => 'datetime',
    ];

    public function teams()
{
    return $this->belongsToMany(Team::class, 'teamandleagues', 'league_id', 'team_id');
}
}