<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Fixture extends Model
{
    protected $table = 'fixtures';
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $fillable = [
        'sportmonks_id',
        'league_id',
        'home_team_id',
        'away_team_id',
        'sport_id',
        'season_id',
        'stage_id',
        'group_id',
        'round_id',
        'venue_id',
        'name',
        'starting_at',
        'status',
        'leg',
        'length',
        'placeholder',
        'has_odds',
        'has_premium_odds',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
        'starting_at' => 'datetime',
        'placeholder' => 'boolean',
        'has_odds' => 'boolean',
        'has_premium_odds' => 'boolean',
    ];

    public function league()
    {
        return $this->belongsTo(Leagues::class, 'league_id');
    }

    public function homeTeam()
    {
        return $this->belongsTo(Team::class, 'home_team_id', 'sportmonks_id');
    }

    public function awayTeam()
    {
        return $this->belongsTo(Team::class, 'away_team_id', 'sportmonks_id');
    }
}