<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Match;
use Illuminate\Http\Request;
use App\Models\Matches;

class FootballController extends Controller
{
    public function liveMatches()
    {
        return Matches::whereIn('status', ['LIVE', 'HT'])
            ->orderBy('start_time', 'asc')
            ->paginate(20); // Add pagination
    }

    public function matchDetails($id)
    {
        return Matches::where('sportmonks_id', $id)->firstOrFail();
    }
}