<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('fetch:sportmonks:livescores')->everyThirtySeconds();
        $schedule->command('fetch:sportmonks:fixtures')->everyFiveMinutes();
        $schedule->command('fetch:sportmonks:leagues')->daily();
        $schedule->command('fetch:sportmonks:teams')->daily();
        $schedule->command('fetch:sportmonks:players')->daily();
        $schedule->command('fetch:sportmonks:standings')->hourly();
        $schedule->command('fetch:sportmonks:topscorers')->daily();
        $schedule->command('fetch:sportmonks:odds')->everyMinute();
        $schedule->command('fetch:sportmonks:predictions')->hourly();
    }

    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}